<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CustomQueryController extends Controller
{
    public function customQuery()
    {
        // Query kustom
        DB::statement("SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");

        $results = DB::select("SELECT P_ProjectID project_id,
                        P_ProjectDate project_date,
                        P_ProjectNumber project_number,
                        P_ProjectM_CustomerID project_customer,
                        IFNULL(P_ProjectAddress, '') project_address,
                        IFNULL(P_ProjectM_CityID, 0) project_city,
                        IFNULL(P_ProjectM_DistrictID, 0) project_district,
                        P_ProjectTargetDate	project_target_date,
                        P_ProjectNote project_note,	
                        P_ProjectM_EmployeeID project_employee,
                        
                        IFNULL(M_TimelineName, '') timeline_name,

                        M_CustomerName customer_name,
                        IFNULL(M_EmployeeName, '') employee_name,

                        IFNULL(M_TimelineSort, 0) timeline_sort,
                        23 as timeline_cnt,
                        round(IFNULL(M_TimelineSort, 0) * 100 / 23) as `percentage`,

                        P_ProjectProgress project_progress,
                        P_ProjectDuration project_duration,
                        P_ProjectDelay project_delay

                        FROM p_project
                        JOIN m_customer ON P_ProjectM_CustomerID = M_CustomerID
                        LEFT JOIN m_timeline ON P_ProjectM_TimelineID = M_TimelineID
                        LEFT JOIN m_employee ON P_ProjectM_EmployeeID = M_EmployeeID
                        WHERE P_ProjectIsActive = 'Y'
                        AND P_ProjectID = :project_id", ["project_id" => 1]);

        // $results = DB::select("SELECT M_CustomerID customer_id, M_CustomerName customer_name,
        //         M_CustomerAddress customer_address, M_CustomerCode customer_code,
        //         IFNULL(M_KelurahanName, '') village_name,
        //         IFNULL(M_DistrictName, '') district_name,
        //         IFNULL(M_CityName, '') city_name,
        //         IFNULL(M_ProvinceName, '') province_name,
        //         M_ProvinceID province_id, M_CityID city_id, 
        //         M_DistrictID district_id, M_KelurahanID village_id,
        //         M_CustomerEmail customer_email, M_CustomerNote customer_note, M_CustomerPostCode customer_postcode,
        //         M_CustomerPhone customer_phone, M_customerPICName customer_pic_name,
        //         M_CustomerPICPhone customer_pic_phone, M_CustomerNPWP customer_npwp,
        //         M_CustomerIsCompany customer_type,
        //         IFNULL(M_CustomerPhones, '[]') customer_phones,
        //         M_CustomerS_StaffID customer_staff, M_CustomerProspect customer_prospect,
        //         COUNT(P_ProjectID) as project_count,
        //         M_CustomerCreated customer_created

        //         FROM `m_customer`
        //         LEFT JOIN m_kelurahan ON M_CustomerM_KelurahanID = M_KelurahanID
        //         LEFT JOIN m_district ON M_CustomerM_DistrictID = M_DistrictID
        //         LEFT JOIN m_city ON M_CustomerM_CityID = M_CityID
        //         LEFT JOIN m_province ON M_CityM_ProvinceID = M_ProvinceID
        //         LEFT JOIN p_project ON P_ProjectM_CustomerID = M_CustomerID AND P_ProjectIsActive = 'Y' AND P_ProjectDone = 'N'
        //         WHERE M_CustomerID = :customer_id
        //         AND `M_CustomerIsActive` = 'Y'
        //         GROUP BY M_CustomerID", ['customer_id' => 1]);

        // $results = DB::select('SELECT * FROM m_customer WHERE M_CustomerIsActive = :some_column', [
        //     'some_column' => 'Y'
        // ]);


        // foreach ($r as $k => $v)
        // {
        //     $r[$k]['customer_phones'] = json_decode($v['customer_phones']);

        //     $date1 = new DateTime('2022-01-15');
        //     $date2 = new DateTime();
        //     $interval = $date1->diff($date2);

        //     $years = $interval->y;
        //     $months = $interval->m;
        //     $days = $interval->d;

        //     $r[$k]['customer_age'] = sprintf("%d hari %d bulan %d tahun", $days, $months, $years);
        // }



        // Mengembalikan hasil ke view
        return response()->json($results[0]);
    }

    public function checkProject(Request $request)
    {
        $projectNumber = $request->input('project_number');

        // Query untuk mendapatkan detail proyek berdasarkan project_number
        $results = DB::select("
            SELECT 
                   P_ProjectNumber AS project_number,
                   P_ProjectMd5 AS project_code
            FROM p_project
            WHERE P_ProjectIsActive = 'Y'
            AND P_ProjectNumber = :project_number
        ", ['project_number' => $projectNumber]);



        // Check jika hasil pencarian ada
        if (!empty($results)) {
            return response()->json([
                'status' => 'OK',
                'project' => $results[0]
            ]);
        } else {
            return response()->json([
                'status' => 'ERR',
                'message' => 'Project Tidak Ditemukan.'
            ]);
        }

        // if (!empty($results)) {
        //     // If project found, return JSON response with data
        //     return response()->json([
        //         'status' => 'OK',
        //         'data' => $results[0] // Assuming only one result is expected
        //     ]);
        // } else {
        //     // If project not found, return JSON response with error message
        //     return response()->json([
        //         'status' => 'ERR',
        //         'message' => 'Project Tidak Ditemukan.'
        //     ]);
        // }
    }
}
