<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProjectController extends Controller
{
    public function viewHome($param)
    {
        // Assuming you want to pass $param to the view
        return view('home', ['param' => $param]);
    }

    public function getHeader()
    {
        // Query kustom
        DB::statement("SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");

        $results = DB::select("SELECT P_ProjectID project_id,
                        P_ProjectDate project_date,
                        P_ProjectNumber project_number,
                        P_ProjectM_CustomerID project_customer,
                        IFNULL(P_ProjectAddress, '') project_address,
                        IFNULL(P_ProjectM_CityID, 0) project_city,
                        IFNULL(P_ProjectM_DistrictID, 0) project_district,
                        P_ProjectTargetDate	project_target_date,
                        P_ProjectNote project_note,	
                        P_ProjectM_EmployeeID project_employee,
                        
                        IFNULL(M_TimelineName, '') timeline_name,

                        M_CustomerName customer_name,
                        IFNULL(M_EmployeeName, '') employee_name,

                        IFNULL(M_TimelineSort, 0) timeline_sort,
                        23 as timeline_cnt,
                        round(IFNULL(M_TimelineSort, 0) * 100 / 23) as `percentage`,

                        P_ProjectProgress project_progress,
                        P_ProjectDuration project_duration,
                        P_ProjectDelay project_delay,

                        IFNULL(M_CityName, '') city_name,
                        IFNULL(M_ProvinceName, '') province_name

                        FROM p_project
                        JOIN m_customer ON P_ProjectM_CustomerID = M_CustomerID
                        LEFT JOIN m_timeline ON P_ProjectM_TimelineID = M_TimelineID
                        LEFT JOIN m_employee ON P_ProjectM_EmployeeID = M_EmployeeID
                        LEFT JOIN m_city ON P_ProjectM_CityID = M_CityID
                        LEFT JOIN m_province ON M_CityM_ProvinceID = M_ProvinceID
                        WHERE P_ProjectIsActive = 'Y'
                        AND P_ProjectID = :project_id", ["project_id" => 1]);

        return response()->json($results[0]);
    }

    public function getHeaderX($param)
    {
        // Query kustom
        DB::statement("SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");

        $results = DB::select("SELECT P_ProjectID project_id,
                        P_ProjectDate project_date,
                        P_ProjectNumber project_number,
                        P_ProjectM_CustomerID project_customer,
                        IFNULL(P_ProjectAddress, '') project_address,
                        IFNULL(P_ProjectM_CityID, 0) project_city,
                        IFNULL(P_ProjectM_DistrictID, 0) project_district,
                        P_ProjectTargetDate project_target_date,
                        P_ProjectNote project_note,    
                        P_ProjectM_EmployeeID project_employee,
                        
                        IFNULL(M_TimelineName, '') timeline_name,
                        IFNULL(M_TimelineName, '') timeline_customer_name,
                        IFNULL(M_TimelineImage, null) timeline_customer_image,
    
                        M_CustomerName customer_name,
                        IFNULL(M_EmployeeName, '') employee_name,
    
                        IFNULL(M_TimelineSort, 0) timeline_sort,
                        23 as timeline_cnt,
                        round(IFNULL(M_TimelineSort, 0) * 100 / 23) as `percentage`,
    
                        IFNULL(P_ProjectProgress, 0)  project_progress,
                        P_ProjectDuration project_duration,
                        P_ProjectDelay project_delay,
    
                        IFNULL(M_CityName, '') city_name,
                        IFNULL(M_ProvinceName, '') province_name
    
                        FROM p_project
                        JOIN m_customer ON P_ProjectM_CustomerID = M_CustomerID
                        LEFT JOIN m_timeline ON P_ProjectM_TimelineID = M_TimelineID
                        LEFT JOIN m_timelinecustomer ON M_TimelineM_TimelineCustomerID = M_TimelineCustomerID
                        LEFT JOIN m_employee ON P_ProjectM_EmployeeID = M_EmployeeID
                        LEFT JOIN m_city ON P_ProjectM_CityID = M_CityID
                        LEFT JOIN m_province ON M_CityM_ProvinceID = M_ProvinceID
                        WHERE P_ProjectIsActive = 'Y' 
                        AND P_ProjectMd5 = :project_id", ["project_id" => $param]);

        return response()->json($results[0]);
    }


    // public function getHeader()
    // {
    //     // Mendapatkan koneksi PDO dari konfigurasi database 'mysql'
    //     $pdo = DB::connection('mysql')->getPdo();

    //     // Ambil nilai sql_mode saat ini
    //     $currentSqlModeQuery = $pdo->query("SELECT @@sql_mode");
    //     $currentSqlMode = $currentSqlModeQuery->fetchColumn();

    //     // Mengganti nilai yang tidak diinginkan dari sql_mode
    //     $newSqlMode = str_replace('NO_AUTO_CREATE_USER,', '', $currentSqlMode);
    //     $newSqlMode = str_replace('NO_AUTO_CREATE_USER', '', $newSqlMode);

    //     // Set session sql_mode dengan nilai baru
    //     $pdo->exec("SET SESSION sql_mode = '{$newSqlMode}'");

    //     // Query menggunakan Query Builder
    //     $results = DB::table('p_project')
    //         ->select(
    //             'P_ProjectID as project_id',
    //             'P_ProjectDate as project_date',
    //             'P_ProjectNumber as project_number',
    //             'P_ProjectM_CustomerID as project_customer',
    //             DB::raw('IFNULL(P_ProjectAddress, "") as project_address'),
    //             DB::raw('IFNULL(P_ProjectM_CityID, 0) as project_city'),
    //             DB::raw('IFNULL(P_ProjectM_DistrictID, 0) as project_district'),
    //             'P_ProjectTargetDate as project_target_date',
    //             'P_ProjectNote as project_note',
    //             'P_ProjectM_EmployeeID as project_employee',
    //             DB::raw('IFNULL(M_TimelineName, "") as timeline_name'),
    //             'M_CustomerName as customer_name',
    //             DB::raw('IFNULL(M_EmployeeName, "") as employee_name'),
    //             DB::raw('IFNULL(M_TimelineSort, 0) as timeline_sort'),
    //             DB::raw('ROUND(IFNULL(M_TimelineSort, 0) * 100 / 23) as percentage'),
    //             'P_ProjectProgress as project_progress',
    //             'P_ProjectDuration as project_duration',
    //             'P_ProjectDelay as project_delay',
    //             DB::raw('IFNULL(M_CityName, "") as city_name'),
    //             DB::raw('IFNULL(M_ProvinceName, "") as province_name')
    //         )
    //         ->join('m_customer', 'P_ProjectM_CustomerID', '=', 'M_CustomerID')
    //         ->leftJoin('m_timeline', 'P_ProjectM_TimelineID', '=', 'M_TimelineID')
    //         ->leftJoin('m_employee', 'P_ProjectM_EmployeeID', '=', 'M_EmployeeID')
    //         ->leftJoin('m_city', 'P_ProjectM_CityID', '=', 'M_CityID')
    //         ->leftJoin('m_province', 'M_CityM_ProvinceID', '=', 'M_ProvinceID')
    //         ->where('P_ProjectIsActive', 'Y')
    //         ->where('P_ProjectID', 1)
    //         ->first();

    //     return response()->json($results);
    // }

    public function getWeeklyProgress()
    {
        // Query kustom
        // DB::statement("SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");

        $results = DB::select("SELECT
                                P_ProjectWeekName week_name,
                                P_ProjectWeekNo week_no,
                                P_ProjectWeekStartDate week_sdate,	
                                P_ProjectWeekEndDate week_edate,
                                P_ProjectWeekProgress week_progress
                            FROM p_projectweek
                            WHERE P_ProjectWeekIsActive = 'Y'
                            AND P_ProjectWeekP_ProjectID = :project_id
                            ORDER BY P_ProjectWeekNo", ["project_id" => 1]);

        return response()->json($results);
    }
    public function checkProjectProgress($param)
    {
        // Pertama, cek apakah proyek ada
        $projectCheck = DB::select("
            SELECT 1 
            FROM p_project 
            WHERE P_ProjectMd5 = :project_id
        ", ["project_id" => $param]);

        // Jika proyek tidak ditemukan
        if (empty($projectCheck)) {
            return response()->json([
                'status' => 'ERR',
                'message' => 'Project tidak ada.'
            ]);
        }

        // Jika proyek ada, cek apakah ada sejarah yang tersedia
        $results = DB::select("
        SELECT 
            M_TimelineID AS timeline_id, 
            P_ProjectDetailID AS detail_id, 
            M_TimelineCode AS timeline_code, 
            M_TimelineName AS timeline_name,
            M_TimelineGroupName AS group_name,
            P_ProjectNumber AS project_number,
            IFNULL(P_ProjectDetailNote, 'Segera') AS detail_note,
            P_ProjectDetailDate AS detail_enddate,
            P_ProjectDetailDelay AS detail_delay,
            P_ProjectDetailAttachment AS detail_attachment,
            IFNULL(M_StatusName, 'SEGERA') AS status_name,
            M_TimelineIsPublic AS timeline_public,
            IFNULL(M_StatusCode, '') AS status_code,
            IFNULL(M_StatusColor, 'grey lighten-1') AS status_color,
            IFNULL(M_StatusIcon, 'mdi-history') AS status_icon,
            IFNULL(P_ProjectDetailDate, '-') AS detail_date, 
            IFNULL(P_ProjectDetailTargetDate, '-') AS detail_target_date,
            IF(P_ProjectDetailRevID IS NULL, '[]', 
            CONCAT('[', 
                IFNULL(
                    GROUP_CONCAT(
                        JSON_OBJECT(
                            'rev_id', P_ProjectDetailRevID, 
                            'rev_date', P_ProjectDetailRevDate, 
                            'rev_note', IFNULL(P_ProjectDetailRevNote, ''), 
                            'rev_attachment', IFNULL(P_ProjectDetailRevAttachment, '')
                        )
                    ), 
                    ''
                ), 
            ']') 
        ) AS revisions
        FROM p_projectdetail
        JOIN m_timeline ON P_ProjectDetailM_TimelineID = M_TimelineID
        LEFT JOIN p_projectdetailrev ON P_ProjectDetailID = P_ProjectDetailRevP_ProjectDetailID
            AND P_ProjectDetailRevIsActive = 'Y'
        JOIN m_timelinegroup ON M_TimelineM_TimelineGroupID = M_TimelineGroupID
        LEFT JOIN m_status ON P_ProjectDetailM_StatusID = M_StatusID
        LEFT JOIN p_project ON P_ProjectDetailP_ProjectID = P_ProjectID
        WHERE P_ProjectDetailIsActive = 'Y'
          AND P_ProjectMd5 = :project_id
        GROUP BY M_TimelineID, 
                 P_ProjectDetailID, 
                 M_TimelineCode, 
                 M_TimelineName, 
                 P_ProjectDetailDate, 
                 P_ProjectDetailM_StatusID, 
                 P_ProjectDetailM_EmployeeID, 
                 P_ProjectDetailNote, 
                 P_ProjectDetailAttachment
    ", ["project_id" => $param]);


        // Jika hasil pencarian ada
        if (!empty($results)) {
            $a = 'detail_attachment';
            foreach ($results as $k => $v) {
                if (
                    !is_null($v->$a) &&
                    !empty($v->$a) &&
                    $v->$a != 'null'
                ) {
                    $v->$a = json_decode($v->$a);
                    if (!empty($v->$a->filename))
                        $v->$a->filename = $this->getFullServerHost() . "uploads/" . $v->$a->filename;
                    $results[$k]->$a = $v->$a;
                }
            }

            return response()->json([
                'status' => 'OK',
                'project' => $results
            ]);
        } else {
            // Jika proyek ada tapi sejarah belum tersedia
            return response()->json([
                'status' => 'ERR',
                'message' => 'History belum tersedia.'
            ]);
        }
    }
}
