// store/modules/customer.js
import axios from "axios";

const state = {
    customers: [],
};

const getters = {
    allCustomers: (state) => state.customers,
};

const actions = {
    async fetchCustomers({ commit }) {
        try {
            const response = await axios.get("/api/custom-query");
            commit("setCustomers", response.data);
        } catch (error) {
            console.error("Error fetching customers:", error);
        }
    },
};

const mutations = {
    setCustomers: (state, customers) => {
        state.customers = customers;
    },
};

export default {
    namespaced: true,
    state,
    getters,
    actions,
    mutations,
};
