// store/modules/customer.js
import axios from 'axios';

const state = {
    projects: [],
};

const getters = {
    projects: (state) => state.projects,
};

const actions = {
    async getHeader({ commit }) {
        try {
            const response = await axios.get('/api/get-project-history');
            commit('projects', response.data);
        } catch (error) {
            console.error('Error fetching header:', error);
        }
    },

};

const mutations = {
    setprojects: (state, x) => {
        state.projects = x;
    },
};

export default {
    namespaced: true,
    state,
    getters,
    actions,
    mutations,
};
