// store/modules/customer.js
import axios from 'axios';

const state = {
    headerData: [],
    weeklyProgress: [],
    projectMd5: '',
    Timeline: [],
    message: '',

    showDetail: false
};

const getters = {
    Timeline: (state) => state.Timeline,
    headerData: (state) => state.headerData,
    weeklyProgress: (state) => state.weeklyProgress,
    showDetail: (state) => state.showDetail,
    projectMd5: (state) => state.projectMd5,
    message: (state) => state.message,
};

const actions = {
    async getHeader({ commit }) {
        try {
            const response = await axios.get('/api/get-project-header');
            commit('setHeaderData', response.data);
        } catch (error) {
            console.error('Error fetching header:', error);
        }
    },

    async getHeaderX({ state, commit }) {
        try {
            const response = await axios.get('/api/get-project-header-x/'+state.projectMd5);
            commit('setHeaderData', response.data);
        } catch (error) {
            console.error('Error fetching header:', error);
        }
    },
    async getProject({ state, commit }) {
        try {
            const response = await axios.get('/api/get-project-history/'+state.projectMd5);
            // console.log("kosong:",response.data.project);
            commit('setTimeline', response.data.project);
            commit('setmessage', response.data.message);
            console.log(response.data.message);
        } catch (error) {
            console.error('Error fetching header:', error);
        }
    },

    async getWeeklyProgress({ commit }) {
        try {
            const response = await axios.get('/api/get-weekly-progress');
            commit('setWeeklyProgress', response.data);
        } catch (error) {
            console.error('Error fetching header:', error);
        }
    },
};

const mutations = {
    setTimeline: (state, x) => {
        state.Timeline = x;
    },
    setHeaderData: (state, x) => {
        state.headerData = x;
    },
    setmessage: (state, x) => {
        state.message = x;
    },

    setWeeklyProgress: (state, x) => {
        state.weeklyProgress = x
    },

    setShowDetail: (state, x) => {
        state.showDetail = x
    },

    setProjectMd5: (state, x) => [
        state.projectMd5 = x
    ]
};

export default {
    namespaced: true,
    state,
    getters,
    actions,
    mutations,
};
