const mix = require("laravel-mix");
const BrowserSyncPlugin = require("browser-sync-webpack-plugin");

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

mix
  .js("resources/js/app.js", "public/js")
  .sass("resources/sass/app.scss", "public/css")
  .sass("resources/sass/style.scss", "public/css")
  .sass("resources/sass/variables/_base.scss", "public/css")
  .sass("resources/sass/variables/_component.scss", "public/css")
  .sass("resources/sass/variables/_typography.scss", "public/css")

  .webpackConfig({
    plugins: [
      new BrowserSyncPlugin(
        {
          host: "localhost",
          port: 3000,
          proxy: "http://127.0.0.1:8000", // Adjust according to your `php artisan serve` address and port
          files: [
            "app/**/*.php",
            "resources/views/**/*.php",
            "resources/js/**/*.js",
            "resources/js/**/*.vue",
            "resources/css/**/*.css",
          ],
        },
        {
          reload: false,
        }
      ),
    ],
  });

// mix.browserSync({
//     proxy: "http://127.0.0.1:8000/",
// });

if (mix.inProduction()) {
  mix.version();
}
